#pragma once

#include "Flag.h"

/*
 * Time functions
 *
 */

void GetCurrentDateTime(LPTSTR szDateTime);
void GetCurrentDateTimeY2K(LPTSTR szDateTime);

/**
 * Gets current local time and stores it in szTime.
 * szTime must point to at least 20 bytes long buffer
 */

void GetTimeForLog(LPTSTR szTime);

long GetFileNumber(LPCTSTR szFileName); // gets number of file with name <number>.<ext>

long GetFileNumberHex(LPCTSTR szFileName); /* same as above, but <number> is
                                   hexadecimal */

int GetNumberOfEnclosedNames(LPCTSTR szFileName); /* gets number of enclosed directory
						     names, e.g. for D:\FIDO\OUTBOUND\
						     it will be 3 */

int MakeDirStructure(LPCTSTR szDirName, int SkipNumber = 0); /* makes direcory structure,
								but first skips
								SkipNumber of
								directory names */

long GetFreeDirNumber(LPCTSTR szFindFileMask); /* gets free number of file in
                                                  directory
                                                  mask is <DIR>\*.<EXT> */

long GetFreeDirNumberHex(LPCTSTR szFindFileMask); /* same as above, but checks
                                                     hexadecimal numbers */

long int GetFileSize(FILE *f);

int  IsAlpha(char *s);
void RemoveBoundaryQuotes(char *s);
int  GetOnBit(unsigned long bitarray);

bool CheckMask(LPCTSTR szValue, LPCTSTR szMask);
bool IsMask(LPCTSTR szValue);

/**
 * File operation result
 */
enum FileOpResult {
	FO_SUCCEEDED,			// file operation succeeded
	FO_FAILED,				// file operation failed but we don't know reason
	FO_SOURCE_UNAVAILABLE,	// source file unavailable
	FO_DEST_UNAVAILABLE,	// destination file unavailable
	FO_DEST_INVALID,		// destination name contains disallowed symbols
	FO_READ_FAILED,			// failed to read source data
	FO_WRITE_FAILED			// failed to write destination data
};

FileOpResult MyMoveFile(LPCTSTR szSourceFileName, LPCTSTR szDestFileName);
FileOpResult MyCopyFile(LPCTSTR szSourceFileName, LPCTSTR szDestFileName);

void ConvertNameToShort(    LPCTSTR szSrc, LPTSTR szDest);
void ConvertANSINameToShort(LPCTSTR szSrc, LPTSTR szDest);

void StrNCpy(char *Dest, const char *Source, int Number);

void ConvertSoftCR(LPTSTR szData);

void FormatSize(int size, char *buf); // 12345678 -> "12,345,678"

int CreateFileFlag(const char *FlagName);

BOOL parseIntWithCommas(char* str, DWORD& d);
bool ParseYesNo(LPCTSTR szValue, bool& bResult);
bool ParseYesNo(LPCTSTR szValue, CFlag& bResult);

void	removeBoundarySpaces(char* source, char* dest);

int GetDays(WORD wDay, WORD wMonth, WORD wYear); 
// return date as number of days since 01 Jan 2000
// day: 1..31, month: 1..12, year: 0..99

LPTSTR	ConcatStrings( LPTSTR szDest, LPCTSTR szHead, LPCTSTR szTail);
	// szDest = szHead + szTail, returns szDest

const int	STR_BUF_SIZE = 768;

/* Writes ANSI or UNICODE szData string into the hFile file in OEM codepage. 
 * The szData length should not be greater then STR_BUF_SIZE-1
 */
DWORD WriteCharString(HANDLE hFile, LPCTSTR szData);

// char-processing

TCHAR	ToUpper(TCHAR c);
TCHAR	ToLower(TCHAR c);

bool StrToInt(LPCTSTR szValue, int& iValue);

bool HaveSlashes(LPCTSTR szValue);

bool HasSpaces(LPCTSTR szValue);

//template <class T>
void AppendVector(VTString& body, VTString& tail);
